//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;

namespace Source
{
	/// <summary>
	/// Podsumowanie dla EventSourceForm.
	/// </summary>
	public class EventSourceForm : System.Windows.Forms.Form
	{
		const string log = "MyEventLog";
		const string source = "MyEventSource";
		private System.Diagnostics.EventLog eventLog;
		private System.Windows.Forms.TextBox message;
		private System.Windows.Forms.Button sendButton;
		private System.Windows.Forms.TextBox id;
		private System.Windows.Forms.Label idLabel;
		private System.Windows.Forms.ErrorProvider errorProvider;
		private System.Windows.Forms.Label categoryLabel;
		private System.Windows.Forms.TextBox category;
		private System.Windows.Forms.GroupBox eventTypeGroup;
		private System.Windows.Forms.RadioButton radioError;
		private System.Windows.Forms.RadioButton radioFailureAudit;
		private System.Windows.Forms.RadioButton radioInformation;
		private System.Windows.Forms.RadioButton radioSuccessAudit;
		private System.Windows.Forms.RadioButton radioWarning;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public EventSourceForm()
		{
			if(!EventLog.SourceExists(source))
			{
				EventLog.CreateEventSource(source, log);
			}
                
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
				eventLog.Close();
				EventLog.DeleteEventSource(source);
				EventLog.Delete(log);
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.category = new System.Windows.Forms.TextBox();
			this.errorProvider = new System.Windows.Forms.ErrorProvider();
			this.id = new System.Windows.Forms.TextBox();
			this.radioWarning = new System.Windows.Forms.RadioButton();
			this.radioSuccessAudit = new System.Windows.Forms.RadioButton();
			this.message = new System.Windows.Forms.TextBox();
			this.eventTypeGroup = new System.Windows.Forms.GroupBox();
			this.radioInformation = new System.Windows.Forms.RadioButton();
			this.radioFailureAudit = new System.Windows.Forms.RadioButton();
			this.radioError = new System.Windows.Forms.RadioButton();
			this.sendButton = new System.Windows.Forms.Button();
			this.eventLog = new System.Diagnostics.EventLog();
			this.idLabel = new System.Windows.Forms.Label();
			this.categoryLabel = new System.Windows.Forms.Label();
			this.eventTypeGroup.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.eventLog)).BeginInit();
			this.SuspendLayout();
			// 
			// category
			// 
			this.category.Location = new System.Drawing.Point(424, 53);
			this.category.Name = "category";
			this.category.Size = new System.Drawing.Size(58, 20);
			this.category.TabIndex = 4;
			this.category.Text = "0";
			this.category.Validating += new System.ComponentModel.CancelEventHandler(this.OnCategoryValidating);
			// 
			// errorProvider
			// 
			this.errorProvider.DataMember = null;
			// 
			// id
			// 
			this.id.Location = new System.Drawing.Point(424, 23);
			this.id.Name = "id";
			this.id.Size = new System.Drawing.Size(58, 20);
			this.id.TabIndex = 2;
			this.id.Text = "0";
			this.id.Validating += new System.ComponentModel.CancelEventHandler(this.OnIdValidating);
			// 
			// radioWarning
			// 
			this.radioWarning.Location = new System.Drawing.Point(15, 114);
			this.radioWarning.Name = "radioWarning";
			this.radioWarning.Size = new System.Drawing.Size(95, 22);
			this.radioWarning.TabIndex = 4;
			this.radioWarning.Text = "Ostrzeenie";
			// 
			// radioSuccessAudit
			// 
			this.radioSuccessAudit.Location = new System.Drawing.Point(15, 91);
			this.radioSuccessAudit.Name = "radioSuccessAudit";
			this.radioSuccessAudit.Size = new System.Drawing.Size(102, 23);
			this.radioSuccessAudit.TabIndex = 3;
			this.radioSuccessAudit.Text = "Kontrola sukcesu";
			// 
			// message
			// 
			this.message.Location = new System.Drawing.Point(7, 23);
			this.message.Name = "message";
			this.message.Size = new System.Drawing.Size(278, 20);
			this.message.TabIndex = 0;
			this.message.Text = "";
			// 
			// eventTypeGroup
			// 
			this.eventTypeGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																						 this.radioWarning,
																						 this.radioSuccessAudit,
																						 this.radioInformation,
																						 this.radioFailureAudit,
																						 this.radioError});
			this.eventTypeGroup.Location = new System.Drawing.Point(321, 91);
			this.eventTypeGroup.Name = "eventTypeGroup";
			this.eventTypeGroup.Size = new System.Drawing.Size(161, 151);
			this.eventTypeGroup.TabIndex = 5;
			this.eventTypeGroup.TabStop = false;
			this.eventTypeGroup.Text = "Typ zdarzenia";
			// 
			// radioInformation
			// 
			this.radioInformation.Checked = true;
			this.radioInformation.Location = new System.Drawing.Point(15, 68);
			this.radioInformation.Name = "radioInformation";
			this.radioInformation.Size = new System.Drawing.Size(102, 23);
			this.radioInformation.TabIndex = 2;
			this.radioInformation.TabStop = true;
			this.radioInformation.Text = "Informacja";
			// 
			// radioFailureAudit
			// 
			this.radioFailureAudit.Location = new System.Drawing.Point(15, 45);
			this.radioFailureAudit.Name = "radioFailureAudit";
			this.radioFailureAudit.Size = new System.Drawing.Size(95, 23);
			this.radioFailureAudit.TabIndex = 1;
			this.radioFailureAudit.Text = "Kontrola niepowodzenia";
			// 
			// radioError
			// 
			this.radioError.Location = new System.Drawing.Point(15, 23);
			this.radioError.Name = "radioError";
			this.radioError.Size = new System.Drawing.Size(95, 22);
			this.radioError.TabIndex = 0;
			this.radioError.Text = "Bd";
			// 
			// sendButton
			// 
			this.sendButton.Location = new System.Drawing.Point(117, 220);
			this.sendButton.Name = "sendButton";
			this.sendButton.Size = new System.Drawing.Size(68, 21);
			this.sendButton.TabIndex = 6;
			this.sendButton.Text = "Wylij";
			this.sendButton.Click += new System.EventHandler(this.OnMessageSend);
			// 
			// eventLog
			// 
			this.eventLog.Log = log;
			this.eventLog.Source = source;
			this.eventLog.EnableRaisingEvents = true;
			this.eventLog.SynchronizingObject = this;
			// 
			// idLabel
			// 
			this.idLabel.Location = new System.Drawing.Point(321, 30);
			this.idLabel.Name = "idLabel";
			this.idLabel.Size = new System.Drawing.Size(92, 15);
			this.idLabel.TabIndex = 1;
			this.idLabel.Text = "Identyfikator wiadomoci";
			// 
			// categoryLabel
			// 
			this.categoryLabel.Location = new System.Drawing.Point(321, 61);
			this.categoryLabel.Name = "categoryLabel";
			this.categoryLabel.Size = new System.Drawing.Size(92, 15);
			this.categoryLabel.TabIndex = 3;
			this.categoryLabel.Text = "Kategoria";
			// 
			// EventSourceForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(496, 265);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.eventTypeGroup,
																		  this.category,
																		  this.categoryLabel,
																		  this.idLabel,
																		  this.id,
																		  this.sendButton,
																		  this.message});
			this.Name = "EventSourceForm";
			this.Text = "rdo zdarze";
			this.eventTypeGroup.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.eventLog)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new EventSourceForm());
		}

		private void OnMessageSend(object sender, System.EventArgs e)
		{
			EventLogEntryType t = EventLogEntryType.Information;
			if(radioError.Checked)
			{
				t = EventLogEntryType.Error;
			}
			if(radioFailureAudit.Checked)
			{
				t = EventLogEntryType.FailureAudit;
			}
			if(radioInformation.Checked)
			{
				t = EventLogEntryType.Information;
			}
			if(radioSuccessAudit.Checked)
			{
				t = EventLogEntryType.SuccessAudit;
			}
			if(radioWarning.Checked)
			{
				t = EventLogEntryType.Warning;
			}
			eventLog.WriteEntry(message.Text,
				                t,
				                Convert.ToInt32(id.Text),
				                Convert.ToInt16(category.Text));
		}

		private void OnCategoryValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			TextBox t = sender as TextBox;
			try 
			{
				short x;
				if(t.Text.Length == 0)
					t.Text = "0";
				else
				{
					x = Int16.Parse(t.Text);
				}
				errorProvider.SetError(t, "");
			}
			catch(FormatException) 
			{
				errorProvider.SetError(t, string.Format("\"{0}\" nie jest wartoci short.", t.Text));
				throw;
			}
			catch(OverflowException) 
			{
				errorProvider.SetError(t, string.Format("Wynikowa warto short jest > {0} lub < {1}.", Int32.MaxValue, Int32.MinValue));
				throw;
			}
			catch(ArgumentNullException) 
			{
				errorProvider.SetError(t, "Pusty cig.");
				throw;
			}

		}

		private void OnIdValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			TextBox t = sender as TextBox;
			try 
			{
				int x;
				if(t.Text.Length == 0)
					t.Text = "0";
				else
				{
					x = Int32.Parse(t.Text);
				}
				errorProvider.SetError(t, "");
			}
			catch(FormatException) 
			{
				errorProvider.SetError(t, string.Format("\"{0}\" nie jest wartoci cakowit.", t.Text));
				throw;
			}
			catch(OverflowException) 
			{
				errorProvider.SetError(t, string.Format("Wynikowa warto cakowita jest > {0} lub < {1}.", Int32.MaxValue, Int32.MinValue));
				throw;
			}
			catch(ArgumentNullException) 
			{
				errorProvider.SetError(t, "Pusty cig.");
				throw;
			}
		}
	}
}
